<?php
/**
 *
 * @version SVN: $Id: alphascramble_install.php 2 2017-08-15 12:15:54Z Norbert Schad $
 * @package Joomla.Admin
 * @subpackage com_alphascramble
 * @author Norbert Schad <norbert.schad@ing-schad.de>
 * @copyright Copyright (C) Tue Sep 09 2014 09:22:42 GMT+0200 (Mitteleuropäische Sommerzeit) . All rights reserved.
 * @license GNU General Public License version 2 or later
 *
 */
defined('_JEXEC') or die();

class com_alphascrambleInstallerScript
{

    /**
     * This method is called after a component is uninstalled.
     *
     * @param \stdClass $parent
     *            - Parent object calling this method.
     *            
     * @return void
     */
    public function uninstall($parent)
    {
        if (! JFolder::delete(JPATH_SITE . '/alpha')) {
            echo "<p>Delete ALPHASCRAMBLE folder didn't work, please remove " . JPATH_SITE . "/alpha manually!</p>";
        } else {
            echo "ALPHASCRAMBLE snapshot deleted!";
        }
    }

    /**
     * method to run after an install/update/uninstall method
     *
     * @return void
     */
    function postflight($type, $parent)
    {
        if (JFolder::exists(JPATH_SITE . '/alpha'))
        {
            if (JFolder::delete(JPATH_SITE . '/alpha'))
            {
                echo "Old ALPHASCRAMBLE snapshot deleted!";    
            }
        }
        
        if (($type == 'install') || ($type == 'update')) {
            $this->moveAssets();
        }
    }

    private function moveAssets()
    {
        if (! JFolder::move(JPATH_ADMINISTRATOR . '/components/com_alphascramble/assets/', JPATH_SITE . '/alpha')) {
            echo "<p>Move folder didn't work!</p>";
        }
    }
}
