<?php
/**
 *
 * @version SVN: $Id: alphascramble.php 2 2017-08-15 12:15:54Z Norbert Schad $
 * @package Joomla.Admin
 * @subpackage com_alphascramble
 * @author Norbert Schad <norbert.schad@ing-schad.de>
 * @copyright Copyright (C) 2017 Ingenieurbüro Norbert Schad. All rights reserved.
 * @license GNU General Public License version 2 or later
 *
 */
defined('_JEXEC') or die();

/**
 * Alphascramble Helper class for the Alphascramble package.
 *
 * @package Joomla.Admin
 * @subpackage com_alphascramble
 */
class AlphascrambleHelper
{
    
    /**
     * Gets a list of the actions that can be performed.
     *
     * @param int $categoryId The category ID.
     *
     * @return JObject
     *
     * @since 1.6
     */
    public static function getActions($categoryId = 0)
    {
        $user = JFactory::getUser();
        $result = new JObject();
        
        $assetName = 'com_Alphascramble';
        $level = 'component';
        
        $actions = JAccess::getActions('com_alphascramble', $level);
        
        foreach ( $actions as $action )
        {
            $result->set($action->name, $user->authorise($action->name, $assetName));
        }
        
        return $result;
    }
}